@extends('layouts.app')

@section('main')

<!-- Content Header -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Expense</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">Add/Update Expense</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<!-- Add/Update Expense Form Section -->
<section class="content">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Please Enter Valid Data</h3>
                    </div>
                    <!-- /.card-header -->

                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    <!-- form start -->
                    <form action="{{ route('expenses.store') }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <!-- Expense Date -->
                            <div class="form-group">
                                <label for="expense_date">Expense Date <span class="text-danger">*</span></label>
                                <input type="date" id="expense_date" name="expense_date" class="form-control" value="{{ date('Y-m-d') }}" required onclick="this.showPicker()">
                            </div>

                            <!-- Category -->
                            <div class="form-group">
                                <label for="category_name">Category <span class="text-danger">*</span></label>
                                <select id="category_name" name="category_name" class="form-control" required>
                                    <option>-Select-</option>
                                    <option value="SHOP EXPENSES">SHOP EXPENSES</option>
                                    <option value="STAFF SALARY">STAFF SALARY</option>
                                    <option value="SHOP RENT / ETC">SHOP RENT / ETC</option>
                                    <option value="PERSONAL EXPENSES">PERSONAL EXPENSES</option>
                                    <option value="ANOTHER EXPENSES">ANOTHER EXPENSES</option>
                                </select>
                            </div>

                            <!-- Expense For -->
                            <div class="form-group">
                                <label for="expense_for">Expense For <span class="text-danger">*</span></label>
                                <input type="text" id="expense_for" name="expense_for" class="form-control" required>
                            </div>

                            <!-- Amount -->
                            <div class="form-group">
                                <label for="amount">Amount <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" id="amount" name="amount" class="form-control" required>
                            </div>

                            <!-- Note -->
                            <div class="form-group">
                                <label for="note">Note</label>
                                <textarea id="note" name="note" class="form-control" rows="4"></textarea>
                            </div>
                        </div>
                        <!-- /.card-body -->

                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Save</button>
                            <button type="button" class="btn btn-secondary" onclick="window.location='{{ url()->previous() }}'">Close</button>
                        </div>
                    </form>
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

@endsection
